//
//  ComAir5API.h
//  ComAir5Library
//
//  Created by GeneralPlus_sa1 on 13/7/12.
//
//

#ifndef _COMAIR5API_H
#define _COMAIR5API_H

#include <MacTypes.h>


#if defined(__cplusplus)
extern "C" {
#endif
//--------------------------------------------------
//Error code
//--------------------------------------------------
#define		COMAIR5_NOERR					0
#define	    COMAIR5_AUDIONOTINIT            1
#define		COMAIR5_AUIDOUINTFAILED			2
#define		COMAIR5_ENABLEIORECFAILED		3
#define		COMAIR5_PROPERTYNOTFOUND        4
#define		COMAIR5_PROPERTYOPERATIONFAILED 5
#define		COMAIR5_PROPERTYSIZEMISSMATCH   6
#define		COMAIR5_PLAYCOMAIR5SOUNDFAILED	7	
//--------------------------------------------------
//Defines
//--------------------------------------------------
typedef struct tagComAir5CommandList
{
	int		i32command;
	Float32 f32Delay;
		
}S_ComAir5CommnadList;
	
typedef int (*PFN_UserCallBack) (int i32Commnad);
typedef int (*PFN_UserRawDataCallBack) (unsigned char* pbyRawData,int i32Size);
	
typedef enum
{
	eComAir5PropertyTarget_Encode  = 0 ,
	eComAir5PropertyTarget_Decode  = 1 ,
		
}eComAir5PropertyTarget;
	

typedef enum
{
	eComAir5Property_RegCode              = 0 ,  //Encode/Decode,Set only,String
	eComAir5Property_CentralFreq          = 1 ,	 //Encode/Decode,Set/Get,Int
	eComAir5Property_iDfValue             = 2 ,	 //Encode/Decode,Set/Get,Int
	eComAir5Property_CmdCallBack          = 3 ,  //Decode,Set,Function Pointer
	eComAir5Property_RawDataCallBack      = 4 ,  //Decode,Set,Function Pointer
    eComAir5Property_Threshold            = 5    //Decode,Set/Get,Int
	
}eComAir5Property;
//-------------------------------------------------
//Functions
//-------------------------------------------------
int		InitComAir5();
int		UnitComAir5();
	
int		StartComAir5Decode();
int		StopComAir5Decode();
	
//Property
int     SetComAir5Property(eComAir5PropertyTarget eTarget,eComAir5Property eProperty,void *vpValue,int i32ValueSize);
int     GetComAir5Property(eComAir5PropertyTarget eTarget,eComAir5Property eProperty,void *vpValue,int i32ValueSize);
	
//Playback
int		PlayComAir5Cmd(int i32command,Float32 SoundVolume);
int		PlayComAir5CmdList(int i32Cnt,S_ComAir5CommnadList *pCommandList,Float32 SoundVolume);
bool    IsComAirCmd5Playing();
	
	
#if defined(__cplusplus)
}
#endif

#endif